﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace Inet.Viewer.WinForms.Prompt
{
    public partial class DateTimeComboBox : UserControl
    {
        private IList<DateTime> defaultValues;
        /// <summary>
        /// Will get fired if the value of the DateTimeComboBox was changed.
        /// </summary>
        public event EventHandler ValueChanged;

        /// <summary>
        /// Initialize the DateTimeComboBox
        /// </summary>
        public DateTimeComboBox()
        {
            InitializeComponent();
            button.Visible = false;
        }
    
        /// <summary>
        /// The value of the DateTimeComboBox
        /// </summary>
        public DateTime Value
        {
            get
            {
                return dateTimePicker.Value;
            }
            set
            {
                if (defaultValues != null)
                {
                    comboBox.SelectedIndex = defaultValues.IndexOf(value);
                }
                dateTimePicker.Value = value;
            }
        }

        /// <summary>
        /// the custom format of the DateTime combobox
        /// </summary>
        public string CustomFormat
        {
            set
            {
                dateTimePicker.CustomFormat = value;
                dateTimePicker.Format = DateTimePickerFormat.Custom;
            }
            get
            {
                return dateTimePicker.CustomFormat;
            }
        }

        /// <summary>
        /// Sets the ShowUpDown property of the DateTimePicker
        /// </summary>
        public bool ShowUpDown
        {
            set
            {
                dateTimePicker.ShowUpDown = value;
            }
        }

        internal bool DefaultsOnly
        {
            set
            {
                comboBox.Visible = value;
                button.Visible = !value;
                dateTimePicker.Visible = !value;
            }
        }

        internal DateTime MinDate
        {
            get
            {
                return dateTimePicker.MinDate;
            }
            set
            {
                dateTimePicker.MinDate = value;
            }
        }

        internal DateTime MaxDate
        {
            get
            {
                return dateTimePicker.MaxDate;
            }
            set
            {
                dateTimePicker.MaxDate = value;
            }
        }

        internal IList<DateTime> DefaultValues
        {   
            set
            {
                this.defaultValues = value;
                comboBox.Items.Clear();
                foreach(DateTime dt in value) {
                    comboBox.Items.Add(new DateTimeItem(this,dt));
                }
                button.Visible = defaultValues.Count > 0;
                int i = defaultValues.IndexOf(dateTimePicker.Value);
                if (i != -1)
                {
                    comboBox.SelectedIndex = defaultValues.IndexOf(dateTimePicker.Value);
                }
            }
        }
 
        private void button1_Click(object sender, EventArgs e)
        {
            comboBox.DroppedDown = true;
        }

        private void comboBox1_DropDownClosed(object sender, EventArgs e)
        {
            if (dateTimePicker.Visible)
            {
                dateTimePicker.Focus();
            }
        }

        private void dateTimePicker1_ValueChanged(object sender, EventArgs e)
        {
            if (ValueChanged != null)
            {
                ValueChanged.Invoke(this, e);
            }
        }

        private void comboBox_SelectedValueChanged(object sender, EventArgs e)
        {
            DateTimeItem item = (DateTimeItem)comboBox.SelectedItem;
            if (item != null) {
                dateTimePicker.Value = item.DateTime;
            }
        }

        private class DateTimeItem
        {
            private DateTime dateTime;
            private DateTimeComboBox combobox;

            internal DateTimeItem(DateTimeComboBox combobox, DateTime dateTime)
            {
                this.combobox = combobox;
                this.dateTime = dateTime;
            }

            public override string ToString()
            {
                return dateTime.ToString(combobox.CustomFormat);
            }

            internal DateTime DateTime
             {
                get {
                    return dateTime;
                }
            }
        }
    }
}
